﻿using System;

using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace PanelWyboruKoloru
{
    public partial class PanelWyboruKoloru : UserControl
    {
        public PanelWyboruKoloru()
        {
            InitializeComponent();
            PanelWyboruKoloru_Resize(null, null);
        }

        private void trackBar1_ValueChanged(object sender, EventArgs e)
        {
            panel1.BackColor = Color.FromArgb(
                trackBar1.Value,
                trackBar2.Value,
                trackBar3.Value);

            OnKolorZmieniony(this, new KolorEventArgs(Kolor));
        }

        public Color Kolor
        {
            get
            {
                return panel1.BackColor;
            }
            set
            {
                trackBar1.Value = value.R;
                trackBar2.Value = value.G;
                trackBar3.Value = value.B;
            }
        }

        private void PanelWyboruKoloru_Resize(object sender, EventArgs e)
        {
            panel1.Width = this.ClientRectangle.Width / 3;

            int wysokoscSuwaka = panel2.ClientRectangle.Height / 3;
            trackBar3.Height = wysokoscSuwaka;
            trackBar2.Height = wysokoscSuwaka;
            trackBar1.Height = wysokoscSuwaka;
        }

        #region Zdarzenie
        public delegate void KolorZmienionyEventHandler(object sender, KolorEventArgs e);
                
        public event KolorZmienionyEventHandler KolorZmieniony;

        protected virtual void OnKolorZmieniony(object sender, KolorEventArgs e)
        {
            if (KolorZmieniony != null) KolorZmieniony(sender, e);
        }
        #endregion
    }

    public class KolorEventArgs : EventArgs
    {
        private Color kolor;

        public KolorEventArgs(Color kolor)
        {
            this.kolor = kolor;
        }

        public Color Kolor
        {
            get
            {
                return kolor;
            }
        }
    }
}